CREATE OR REPLACE procedure P_ADMS_AGENT_REPLACE
(
sAbbrOld        in varchar2,
sAccOld         in varchar2,
sAbbrNew        in varchar2,
sAccNew         in varchar2,
sResult         out varchar2
)
-- v. 1.01  10.02.2004 
--    

as
nAgentOld       number( 17 );
nAccOld         number( 17 );
nAgentNew       number( 17 );
nAccNew         number( 17 );
begin
sResult:='';

begin
  select RN into nAgentOld
    from AGNLIST
   where AGNLIST.AGNABBR = sAbbrOld;
exception when NO_DATA_FOUND then
  P_EXCEPTION( 0,'    '||sAbbrOld||'  ');
end;

begin
  select RN into nAgentNew
    from AGNLIST
   where AGNLIST.AGNABBR = sAbbrNew;
exception when NO_DATA_FOUND then
  P_EXCEPTION( 0,'    '||sAbbrNew||'  ');
end;

if     Trim( sAccOld ) IS NOT NULL
   and Trim( sAccNew ) IS NOT NULL then
begin
  select RN into nAccOld
    from AGNACC
   where AGNACC.AGNRN = nAgentOld
     and AGNACC.STRCODE = sAccOld;
exception when NO_DATA_FOUND then
  P_EXCEPTION(0, '   '||sAccOld||'   '||sAbbrOld||'  ');
end;
begin
  select RN into nAccNew
    from AGNACC
   where AGNACC.AGNRN = nAgentNew
     and AGNACC.STRCODE = sAccNew;
exception when NO_DATA_FOUND then
  P_EXCEPTION( 0,'   '||sAccNew||'   '||sAbbrNew||'  ');
end;
end if;

-- 1
--execute immediate 'alter table INCOMDOC disable all triggers';
update INCOMDOC
   set INCOMDOC.AGENT = nAgentNew
 WHERE INCOMDOC.AGENT = nAgentOld;
--execute immediate 'alter table INCOMDOC enable all triggers';

-- 2
--execute immediate 'alter table TRANSINVDEPT disable all triggers';
update TRANSINVDEPT
   set TRANSINVDEPT.IN_MOL = nAgentNew
 WHERE TRANSINVDEPT.IN_MOL = nAgentOld;
--execute immediate 'alter table TRANSINVDEPT enable all triggers';

-- 3
--execute immediate 'alter table SALESREPORTDETAIL disable all triggers';
update SALESREPORTDETAIL
   set SALESREPORTDETAIL.AGENT = nAgentNew
 WHERE SALESREPORTDETAIL.AGENT = nAgentOld;
--execute immediate 'alter table SALESREPORTDETAIL enable all triggers';

-- 4
--execute immediate 'alter table MDLCOSPS disable all triggers';
update MDLCOSPS
   set MDLCOSPS.agent_from = nAgentNew
 WHERE MDLCOSPS.agent_from = nAgentOld;
update MDLCOSPS
   set MDLCOSPS.agent_to = nAgentNew
 WHERE MDLCOSPS.agent_to = nAgentOld;
--execute immediate 'alter table MDLCOSPS enable all triggers';

-- 5
--execute immediate 'alter table MDLDAFFS disable all triggers';
update MDLDAFFS
   set MDLDAFFS.agent_from = nAgentNew
 WHERE MDLDAFFS.agent_from = nAgentOld;
update MDLDAFFS
   set MDLDAFFS.agent_to = nAgentNew
 WHERE MDLDAFFS.agent_to = nAgentOld;
--execute immediate 'alter table MDLDAFFS enable all triggers';

-- 6
--execute immediate 'alter table CASHDOCS disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_CASHDOCS_BUPDATE DISABLE';
update CASHDOCS
   set CASHDOCS.agent_from = nAgentNew
 WHERE CASHDOCS.agent_from = nAgentOld;
update CASHDOCS
   set CASHDOCS.agent_to = nAgentNew
 WHERE CASHDOCS.agent_to = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_CASHDOCS_BUPDATE ENABLE';
--execute immediate 'alter table CASHDOCS enable all triggers';

-- 7
--execute immediate 'alter table ECONOPRS disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ECONOPRS_BUPDATE DISABLE';
update ECONOPRS
   set ECONOPRS.agent_from = nAgentNew
 WHERE ECONOPRS.agent_from = nAgentOld;
update ECONOPRS
   set ECONOPRS.agent_to = nAgentNew
 WHERE ECONOPRS.agent_to = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ECONOPRS_BUPDATE ENABLE';
--execute immediate 'alter table ECONOPRS enable all triggers';

-- 8
--execute immediate 'alter table MDLCDOCS disable all triggers';
update MDLCDOCS
   set MDLCDOCS.agent_from = nAgentNew
 WHERE MDLCDOCS.agent_from = nAgentOld;
update MDLCDOCS
   set MDLCDOCS.agent_to = nAgentNew
 WHERE MDLCDOCS.agent_to = nAgentOld;
--execute immediate 'alter table MDLCDOCS enable all triggers';

-- 9
--execute immediate 'alter table MDLEOPRS disable all triggers';
update MDLEOPRS
   set MDLEOPRS.agent_from = nAgentNew
 WHERE MDLEOPRS.agent_from = nAgentOld;
update MDLEOPRS
   set MDLEOPRS.agent_to = nAgentNew
 WHERE MDLEOPRS.agent_to = nAgentOld;
--execute immediate 'alter table MDLEOPRS enable all triggers';

-- 10
--execute immediate 'alter table ODCTURNS disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ODCTURNS_BUPDATE DISABLE';
update ODCTURNS
   set ODCTURNS.agent_from = nAgentNew
 WHERE ODCTURNS.agent_from = nAgentOld;
update ODCTURNS
   set ODCTURNS.agent_to = nAgentNew
 WHERE ODCTURNS.agent_to = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ODCTURNS_BUPDATE ENABLE';
--execute immediate 'alter table ODCTURNS enable all triggers';

-- 11   
--execute immediate 'alter table DCSPECS disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_DCSPECS_BUPDATE DISABLE';
update DCSPECS
   set DCSPECS.agent = nAgentNew
 WHERE DCSPECS.agent = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_DCSPECS_BUPDATE ENABLE';
--execute immediate 'alter table DCSPECS enable all triggers';

--execute immediate 'alter table CONSUMERORD disable all triggers';
update CONSUMERORD
   set CONSUMERORD.agent = nAgentNew
 WHERE CONSUMERORD.agent = nAgentOld;
--execute immediate 'alter table CONSUMERORD enable all triggers';

--execute immediate 'alter table PAYNOTES disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ADM_PAYNOTES_A DISABLE';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ADM_PAYNOTE_B_D DISABLE';
update PAYNOTES
   set PAYNOTES.PAYER = nAgentNew
 WHERE PAYNOTES.PAYER = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ADM_PAYNOTE_B_D ENABLE';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_ADM_PAYNOTES_A ENABLE';  
--execute immediate 'alter table PAYNOTES enable all triggers';

--execute immediate 'alter table INVENTORY disable all triggers';
update INVENTORY
   set INVENTORY.EXECUTIVE = nAgentNew
 WHERE INVENTORY.EXECUTIVE = nAgentOld;
--execute immediate 'alter table INVENTORY enable all triggers';

--execute immediate 'alter table TRANSINVCUST disable all triggers';
update TRANSINVCUST
   set TRANSINVCUST.FERRYMAN = nAgentNew
 WHERE TRANSINVCUST.FERRYMAN = nAgentOld;
--execute immediate 'alter table TRANSINVCUST enable all triggers';

--execute immediate 'alter table FINPAYCALENDAR disable all triggers';
update FINPAYCALENDAR
   set FINPAYCALENDAR.cal_payer = nAgentNew
 WHERE FINPAYCALENDAR.cal_payer = nAgentOld
   and FINPAYCALENDAR.cal_payer_acc is null;
--execute immediate 'alter table FINPAYCALENDAR enable all triggers';

--execute immediate 'alter table OPRSPECS disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_OPRSPECS_BUPDATE DISABLE';
update OPRSPECS
   set OPRSPECS.VALUES_FROM = nAgentNew
 WHERE OPRSPECS.VALUES_FROM = nAgentOld;
update OPRSPECS
   set OPRSPECS.VALUES_TO = nAgentNew
 WHERE OPRSPECS.VALUES_TO=nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_OPRSPECS_BUPDATE ENABLE';
--execute immediate 'alter table OPRSPECS enable all triggers';

--execute immediate 'alter table ININVOICES disable all triggers';
update ININVOICES
   set ININVOICES.AGENT = nAgentNew
 WHERE ININVOICES.AGENT = nAgentOld;
--execute immediate 'alter table ININVOICES enable all triggers';

--execute immediate 'alter table LIABILITYNOTES disable all triggers';
update LIABILITYNOTES
   set LIABILITYNOTES.AGENT = nAgentNew
 WHERE LIABILITYNOTES.AGENT = nAgentOld;
--execute immediate 'alter table LIABILITYNOTES enable all triggers';


if    Trim(sAccOld) IS NOT NULL
  and Trim(sAccNew) IS NOT NULL then

--execute immediate 'alter table FACEACC disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_FACEACC_BUPDATE DISABLE';
update FACEACC
   set FACEACC.agent = nAgentNew,
       FACEACC.agnacc = nAccNew
 WHERE FACEACC.agent = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_FACEACC_BUPDATE ENABLE';
--execute immediate 'alter table FACEACC enable all triggers';

--execute immediate 'alter table FINPAYCALENDAR disable all triggers';
update FINPAYCALENDAR
   set FINPAYCALENDAR.cal_payer = nAgentNew,
       FINPAYCALENDAR.cal_payer_acc = nAccNew
 WHERE FINPAYCALENDAR.cal_payer = nAgentOld;
update FINPAYCALENDAR
   set FINPAYCALENDAR.CAL_PAYER = nAgentNew,
       FINPAYCALENDAR.CAL_PAYER_ACC = nAccNew
 WHERE FINPAYCALENDAR.CAL_PAYER=nAgentOld;
--execute immediate 'alter table FINPAYCALENDAR enable all triggers';

--execute immediate 'alter table DICACCFO disable all triggers';
update DICACCFO
   set DICACCFO.cs_code = nAgentNew,
       DICACCFO.cs_bank_code = nAccNew
 WHERE DICACCFO.cs_code = nAgentOld;
update DICACCFO
   set DICACCFO.pr_code = nAgentNew,
       DICACCFO.pr_bank_code = nAccNew
 WHERE DICACCFO.pr_code = nAgentOld;
--execute immediate 'alter table DICACCFO enable all triggers';

--execute immediate 'alter table TRANSINVCUST disable all triggers';
update TRANSINVCUST
   set TRANSINVCUST.agent = nAgentNew
--       TRANSINVCUST.faceacc = nAccNew   !     
 WHERE TRANSINVCUST.agent = nAgentOld;
--execute immediate 'alter table TRANSINVCUST enable all triggers';

--execute immediate 'alter table BANKDOCS disable all triggers';
EXECUTE IMMEDIATE 'ALTER TRIGGER T_BANKDOCS_BUPDATE DISABLE';
update BANKDOCS
   set BANKDOCS.agent_from = nAgentNew,
       BANKDOCS.agent_from_acc = nAccNew
 WHERE BANKDOCS.agent_from = nAgentOld;
update BANKDOCS
   set BANKDOCS.agent_to = nAgentNew,
       BANKDOCS.agent_to_acc = nAccNew
 WHERE BANKDOCS.agent_to=nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_BANKDOCS_BUPDATE ENABLE';
--execute immediate 'alter table BANKDOCS enable all triggers';

--execute immediate 'alter table MDLBDOCS disable all triggers';
update MDLBDOCS
   set MDLBDOCS.agent_from = nAgentNew,
       MDLBDOCS.agent_from_acc = nAccNew
 WHERE MDLBDOCS.agent_from = nAgentOld;
update MDLBDOCS
   set MDLBDOCS.agent_to = nAgentNew,
       MDLBDOCS.agent_to_acc = nAccNew
 WHERE MDLBDOCS.agent_to = nAgentOld;
--execute immediate 'alter table MDLBDOCS enable all triggers';

--execute immediate 'alter table CONTRACTS disable all triggers';
update CONTRACTS
   set CONTRACTS.AGENT = nAgentNew,
       CONTRACTS.AGNACC = nAccNew
 WHERE CONTRACTS.AGENT = nAgentOld;
--execute immediate 'alter table CONTRACTS enable all triggers';

end if;

update INORDERS
   set CONTRAGENT = nAgentNew
 WHERE CONTRAGENT = nAgentOld;

update DICACCFI
   set PR_CODE = nAgentNew,
       PR_BANK_CODE = nAccNew
 WHERE PR_CODE = nAgentOld;

EXECUTE IMMEDIATE 'ALTER TRIGGER T_PDDIRECT_BUPDATE DISABLE';
update PDDIRECT
   set AGENT_TO = nAgentNew,
       AGENT_TO_ACC = nAccNew
 WHERE AGENT_TO = nAgentOld;
update PDDIRECT
   set AGENT_FROM = nAgentNew,
       AGENT_FROM_ACC = nAccNew
 WHERE AGENT_FROM = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_PDDIRECT_BUPDATE ENABLE';

/*
EXECUTE IMMEDIATE 'ALTER TRIGGER T_AGNFIFO_BUPDATE DISABLE';
update AGNFIFO
   set PRN = nAgentNew
 WHERE PRN = nAgentOld;
update AGNFIFO
   set DEF_AGENT = nAgentNew
 WHERE DEF_AGENT = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_AGNFIFO_BUPDATE ENABLE';
*/

EXECUTE IMMEDIATE 'ALTER TRIGGER T_AGNADDRESSES_BUPDATE DISABLE';
update AGNADDRESSES
   set PRN = nAgentNew
 WHERE PRN = nAgentOld;
EXECUTE IMMEDIATE 'ALTER TRIGGER T_AGNADDRESSES_BUPDATE ENABLE';

sResult := '   '||sAbbrOld||'   '||sAbbrNew;

end;
/
