create or replace procedure PR_GDV_EXPORT_INVENTORY
(
p_nCOMPANY in number, 
p_dDATE    in date,      --  
v_sMSG     out varchar2  -- 
) 
is
v_file UTL_FILE.FILE_TYPE;
v_bFLAG boolean := true;
v_sFILENAME varchar2(100);
v_nCRN      number(17);
v_nCRN2     number(17);
begin


v_sFILENAME := 'inv_OC_'||to_char(p_dDATE,'ddmmyy')||'.txt';
v_file := UTL_FILE.Fopen( 'd:\export', v_sFILENAME, 'w');

FIND_ACATALOG_NAME
(
  0,
  p_nCOMPANY,
  null,
  'Inventory',
  ' ',
  v_nCRN
);



/*   */
begin   
    UTL_FILE.Put_Line(v_file, '  '||chr(9)
                            ||' '||chr(9)
                            ||' '||chr(9)
                            ||'    '||chr(9)	
                            ||' '||chr(9)	
                            ||' '||chr(9)
                            ||' '
                            );
  exception  
    when UTL_FILE.INVALID_PATH then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '      .  !');
    when UTL_FILE.INVALID_MODE then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '           .  !');
    when UTL_FILE.INVALID_FILEHANDLE then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '     .  !');
    when UTL_FILE.INVALID_OPERATION then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '  /   .  !');
    when UTL_FILE.WRITE_ERROR then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '        .  !');
    when UTL_FILE.INTERNAL_ERROR then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '  PL/SQL     .  !');
    when others then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '      .  !');
  end; 

for REC in 
(
  select I.CARD_PREF||'-'||trim(I.CARD_NUMB) KARD_NUMB,
         D.NOMEN_CODE OBJ_CODE,
         D.NOMEN_NAME OBJ_NAME,
         FR_GDV_FIND_OBJ_INPUT(p_nCOMPANY, I.RN) INPUT_DATE,
         DI.AMORT_CODE,
         I.AB_COST_BEGIN BEGIN_COST, --  
         H.NEW_AB_COST_END END_COST  --  
    from INVENTORY I,
         INVHIST H,
         DICNOMNS D,
         DICAMORT DI
   where I.COMPANY = p_nCOMPANY and
         I.RN = H.PRN and
         I.OBJ_STATUS <> 2 and --   
         I.OBJ_STATUS <> 5 and --     
         H.ACTION_TYPE <> 4 and
         H.ACTION_TYPE <> 8 and
         H.ACTION_TYPE <> 10 and
         I.CRN in (SELECT RN FROM acatalog CT
                              connect by
                                    prior CT.RN = CT.CRN
                                    start with
                                    CT.RN = v_nCRN) and
         I.NOMENCLATURE = D.RN and
         I.AMORT_RN = DI.RN and
         H.RN = (select MAX(IH.RN) --     ,   
                   from INVHIST IH
                  where IH.PRN = I.RN and
                        IH.COMPANY = p_nCOMPANY and
                        trunc(IH.ACTION_DATE) <= p_dDATE) 
)         
loop

  begin
    UTL_FILE.Put_Line(v_file, 
                              REC.KARD_NUMB||chr(9)
                            ||REC.OBJ_CODE||chr(9)
                            ||REC.OBJ_NAME||chr(9)	
                            ||REC.INPUT_DATE||chr(9)
                            ||REC.AMORT_CODE||chr(9)	
                            ||REC.BEGIN_COST||chr(9)
                            ||REC.END_COST
                            );
  exception  
    when UTL_FILE.INVALID_PATH then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '      .  !');
    when UTL_FILE.INVALID_MODE then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '           .  !');
    when UTL_FILE.INVALID_FILEHANDLE then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '     .  !');
    when UTL_FILE.INVALID_OPERATION then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '  /   .  !');
    when UTL_FILE.WRITE_ERROR then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '        .  !');
    when UTL_FILE.INTERNAL_ERROR then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '  PL/SQL     .  !');
    when others then
      UTL_FILE.Fclose(v_file);
      p_exception(0, '      .  !');
  end;  
  
end loop;

UTL_FILE.Fflush(v_file);
UTL_FILE.Fclose(v_file);

v_sMSG := '      (: < >)!';

end PR_GDV_EXPORT_INVENTORY;