create or replace procedure PR_COPY_ROLE_PRIVS
(
  sFROM_ROLE    in varchar2,         --   " "
  sTO_ROLE      in varchar2,         --   ""
  nTO_CLEAR     in number default 0  --    
)
as
  nFROM_ROLE    ROLES.RN%type;
  nTO_ROLE      ROLES.RN%type;
  iCOUNT        integer;
  nPRIV_UNI     PKG_STD.tREF;
  nPRIV_CAT     PKG_STD.tREF;
  nPRIV_CFN     PKG_STD.tREF;
  nPRIV_UFN     PKG_STD.tREF;
  nPRIV_JPR     PKG_STD.tREF;
begin
  
  /*     */
  FIND_ROLES_BY_NAME( 0,sFROM_ROLE,nFROM_ROLE );
  FIND_ROLES_BY_NAME( 0,sTO_ROLE,nTO_ROLE );
  /*    */
  if ( nvl(nTO_CLEAR,0) = 1 ) then
    /*  */
    delete from USERAPPS where ROLEID = nTO_ROLE;
    /*  */
    delete from USERPRIV where ROLEID = nTO_ROLE;
  end if;
  /*    */
  for APP in
  (
    select APPCODE from USERAPPS where ROLEID = nFROM_ROLE
  )
  loop
    /*      */
    select count(*) into iCOUNT
      from USERAPPS
      where ROLEID  = nTO_ROLE
      and APPCODE = APP.APPCODE;
    /*    */
    if ( iCOUNT = 0 ) then
      P_ADMAP2RL_LINK( APP.APPCODE,nTO_ROLE );
    end if;
  end loop;
  /*     */
  for CMP in
  (
    select nvl(COMPANY,0) as COMPANY
    from USERPRIV
    where ROLEID   =  nFROM_ROLE
    and VERSION    is null
    and UNITCODE   is null
    and CATALOG    is null
  )
  loop
    /*      */
    select count(*)into iCOUNT
    from USERPRIV
    where ROLEID       =  nTO_ROLE
    and nvl(COMPANY,0) =  CMP.COMPANY
    and VERSION        is null
    and UNITCODE       is null
    and CATALOG        is null;
    /*     */
    if ( iCOUNT = 0 ) then
      P_ADMCO2RL_LINK(CMP.COMPANY,nTO_ROLE);
    end if;
    /*     */
    for UNI in
    (
      --    /
      select /*+ RULE */
             PR.UNITCODE     as UNITCODE,
             UL.SIGN_HIER    as SIGN_HIER,
             UL.SIGN_JURPERS as SIGN_JURPERS
        from 
             COMPVERLIST       CV,
             COMPANIES         CO,
             USERPRIV          PR,
             UNITLIST UL
        where    (PR.COMPANY is not null or PR.VERSION is not null)
              and PR.CATALOG    is null
              and PR.JUR_PERS   is null
              and (PR.COMPANY   = CO.RN or CV.COMPANY = CO.RN)
              and PR.VERSION    = CV.VERSION(+)
              and PR.UNITCODE   = UL.UNITCODE
              and UL.SIGN_SHARE = 1
              --
              and CO.RN         = CMP.COMPANY
              and PR.ROLEID     = nFROM_ROLE
      union
      --     /
      select 
             PR.UNITCODE        as UNITCODE,
             UL.SIGN_HIER       as SIGN_HIER,
             UL.SIGN_JURPERS    as SIGN_JURPERS
        from USERPRIV           PR,
             UNITLIST           UL
        where     PR.COMPANY    is null
              and PR.VERSION    is null
              and PR.CATALOG    is null
              and PR.JUR_PERS   is null
              and PR.UNITCODE   = UL.UNITCODE
              and UL.SIGN_SHARE = 0
              --
              and 0             = CMP.COMPANY
              and PR.ROLEID     = nFROM_ROLE
    )
    loop
      /*    */
      P_PRIV2UNIT_EXISTS(1,null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,-null,null,null,nPRIV_UNI);
      /*  */
      if ( nPRIV_UNI is null ) then
        P_PRIV2UNIT_BASE_GRANT( null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE );
      end if;
      /*    */
      if ( UNI.SIGN_HIER = 1 ) then
        /*     */
        for CAT in
        (
          -- ,  /
          select /*+ RULE */
                 CT.RN as CATALOG
            from USERPRIV    PR,
                 COMPANIES   CO,
                 COMPVERLIST CV,
                 ACATALOG    CT
            where     (PR.COMPANY is not null or PR.VERSION is not null)
                  and (PR.COMPANY = CO.RN or CV.COMPANY = CO.RN)
                  and PR.VERSION  = CV.VERSION(+)
                  and PR.CATALOG  = CT.RN
                  --
                  and CO.RN       = CMP.COMPANY
                  and PR.ROLEID   = nFROM_ROLE
                  and PR.UNITCODE = UNI.UNITCODE
          union
          -- ,  
          select /*+ RULE */
                 CT.RN as CATALOG
            from USERPRIV PR,
                 ACATALOG CT
            where     PR.COMPANY  is null
                  and PR.VERSION  is null
                  and PR.CATALOG  = CT.RN
                  --
                  and 0           = CMP.COMPANY
                  and PR.ROLEID   = nFROM_ROLE
                  and PR.UNITCODE = UNI.UNITCODE
        )
        loop
          /*    */
          P_PRIV2UNIT_EXISTS( 1,null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,CAT.CATALOG,null,null,nPRIV_CAT );
          /*  */
          if ( nPRIV_CAT is null ) then
            P_PRIV2CTLG_BASE_GRANT( null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,CAT.CATALOG );
          end if;
          /*     */
          for UFN in
          (
            select * 
            from V_PRIV2UNIT 
            where 
                NCOMPANY    = CMP.COMPANY 
            and SMASTERCODE = UNI.UNITCODE 
            order by NLEVEL, SUNITCODE
          )
          loop
            /*      */
            for UFD in
            (
              select /*+ RULE */
                   sUNITCODE, sFUNCCODE, sFUNCNAME, sFUNCNUMB, nACCESS
              from V_ROLEPRIV2FUNC
              where
                  sUNITCODE  = UFN.SUNITCODE
              and nROLEID    = nFROM_ROLE
              and nCOMPANY   = CMP.COMPANY 
              and nCATALOG   = CAT.CATALOG
              and nJUR_PERS  is null 
              and nHIERARCHY is null
              and nACCESS = 1
              /*
              union all
              select
                   sUNITCODE, sFUNCCODE, sFUNCNAME, sFUNCNUMB, nACCESS
              from V_ROLEPRIV2NOTFUNC
              where
                  sUNITCODE  = UFN.SUNITCODE
              and nROLEID    = nFROM_ROLE
              and nCOMPANY   = CMP.COMPANY 
              and nCATALOG   = CAT.CATALOG
              and nJUR_PERS  is null
              and nHIERARCHY is null
              */
              order by sFUNCNUMB
            )            
            loop
              /*    */
              P_PRIV2FUNC_EXISTS( 1,null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,CAT.CATALOG,null,null,UFD.SFUNCCODE,nPRIV_UFN );
              /*  */
              if ( nPRIV_UFN is null ) then
                P_PRIV2FUNC_BASE_GRANT( null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,CAT.CATALOG,null,null,UFD.SFUNCCODE );
              end if;
            end loop;
          end loop;
        end loop /* CAT */;
      end if;

      /*     */
      if ( UNI.SIGN_JURPERS = 1 ) then
        /*      */
        for JPR in
        (
          -- ,  
          select /*+ RULE */
                 JP.RN as JUR_PERS
            from USERPRIV   PR,
                 JURPERSONS JP
            where     PR.JUR_PERS = JP.RN
                  and PR.COMPANY  = CMP.COMPANY
                  and PR.ROLEID   = nFROM_ROLE
                  and PR.UNITCODE = UNI.UNITCODE
        )
        loop
          /*    */
          P_PRIV2UNIT_EXISTS( 1,null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,null,JPR.JUR_PERS,null,nPRIV_JPR );
          /*  */
          if ( nPRIV_JPR is null ) then
            P_PRIV2JURPERS_BASE_GRANT( null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,JPR.JUR_PERS );
          end if;
          /*      */
          for UFN in
          (
            --     (  )
            select /*+ RULE */
                   UF.CODE as FUNCCODE
              from USERPRIV          PR,
                   UNITPRIV          PRF,
                   UNITFUNC          UF,
                   UNITLIST          UL
              where     PR.RN           = PRF.PRN
                    and PRF.FUNC        = UF.CODE
                    and PR.UNITCODE     = UL.UNITCODE
                    and UL.SIGN_SHARE   = 1
                    and UL.SIGN_ACCREG  = 1
                    and UL.SIGN_JURPERS = 1
                    --
                    and PR.COMPANY    = CMP.COMPANY
                    and PR.ROLEID     = nFROM_ROLE
                    and PR.UNITCODE   = UNI.UNITCODE
                    and PR.JUR_PERS   = JPR.JUR_PERS
          )
          loop
            /*    */
             P_PRIV2FUNC_EXISTS( 1,null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,null,JPR.JUR_PERS,null,UFN.FUNCCODE,nPRIV_UFN );
            /*  */
            if ( nPRIV_UFN is null ) then
              P_PRIV2FUNC_BASE_GRANT( null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,null,JPR.JUR_PERS,null,UFN.FUNCCODE );
            end if;
          end loop /* UFN */;
        end loop /* JPR */;
      end if;
      /*    ,      */
      if ( UNI.SIGN_HIER = 0 and UNI.SIGN_JURPERS = 0 ) then
        /*      */
        for UFN in
        (
          --    / (    )
          select /*+ RULE */
                 UF.CODE as FUNCCODE
            from USERPRIV          PR,
                 UNITPRIV          PRF,
                 UNITFUNC          UF,
                 COMPANIES         CO,
                 COMPVERLIST       CV,
                 UNITLIST          UL
            where     PR.RN           = PRF.PRN
                  and PRF.FUNC        = UF.CODE
                  and (PR.COMPANY = CO.RN or CV.COMPANY = CO.RN)
                  and PR.VERSION      = CV.VERSION(+)
                  and PR.UNITCODE     = UL.UNITCODE
                  and UL.SIGN_SHARE   = 1
                  and UL.SIGN_HIER    = 0
                  and UL.SIGN_JURPERS = 0
                  --
                  and CO.RN           = CMP.COMPANY
                  and PR.ROLEID       = nFROM_ROLE
                  and PR.UNITCODE     = UNI.UNITCODE
          union
          --     / (    )
          select /*+ RULE */
                 UF.CODE as FUNCCODE
            from USERPRIV          PR,
                 UNITPRIV          PRF,
                 UNITFUNC          UF,
                 UNITLIST          UL
            where     PR.RN           =  PRF.PRN
                  and PRF.FUNC        =  UF.CODE
                  and PR.COMPANY      is null
                  and PR.VERSION      is null
                  and PR.UNITCODE     =  UL.UNITCODE
                  and UL.SIGN_SHARE   =  0
                  and UL.SIGN_HIER    =  0
                  and UL.SIGN_JURPERS =  0
                  --
                  and 0               = CMP.COMPANY
                  and PR.ROLEID       = nFROM_ROLE
                  and PR.UNITCODE     = UNI.UNITCODE
        )
        loop
          /*    */
          P_PRIV2FUNC_EXISTS( 1,null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,null,null,null,UFN.FUNCCODE,nPRIV_UFN );
          /*  */
          if ( nPRIV_UFN is null ) then            
            P_PRIV2FUNC_BASE_GRANT( null,nTO_ROLE,CMP.COMPANY,UNI.UNITCODE,null,null,null,UFN.FUNCCODE );
          end if;
        end loop /* UFN */;
      end if;
    end loop /* UNI */;
  end loop /* CMP */;
end;
